<?php

if(isset($_SESSION['message'])){
	show_alert($_SESSION['message']['text'], $_SESSION['message']['type']);
	unset($_SESSION['message']);
}

if(isset($_GET['id'])){
	$collection = Collection::getById($_GET['id']);
	if($collection){
		?>
<style>
.game-picker-section {
	border: 1px solid #dcdfe3;
	border-radius: 4px;
	padding: 15px;
	margin-bottom: 15px;
}

.theme-dark .game-picker-section {
	border-color: #3b4a5e;
}

.game-search-box {
	margin-bottom: 15px;
	position: relative;
}

.search-spinner {
	position: absolute;
	right: 10px;
	top: 10px;
	display: none;
}

.game-grid {
	display: grid;
	grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
	gap: 10px;
	max-height: 400px;
	overflow-y: auto;
	padding: 10px;
	border: 1px solid #dcdfe3;
	border-radius: 4px;
	margin-bottom: 10px;
}

.theme-dark .game-grid {
	border-color: #3b4a5e;
}

.game-card {
	border: 2px solid #e0e0e0;
	border-radius: 6px;
	padding: 8px;
	cursor: pointer;
	transition: all 0.2s;
	text-align: center;
	background-color: #fff;
}

.theme-dark .game-card {
	border-color: #4d5579;
	background-color: #333a59;
}

.game-card:hover {
	border-color: #19bae0;
	transform: translateY(-2px);
	box-shadow: 0 3px 6px rgba(0,0,0,0.1);
}

.game-card.selected {
	border-color: #4cd29a;
	background-color: #d4edda;
}

.theme-dark .game-card.selected {
	border-color: #4cd29a;
	background-color: #2d4a3a;
}

.game-card img {
	width: 100%;
	height: 80px;
	object-fit: cover;
	border-radius: 4px;
	margin-bottom: 5px;
}

.game-card-title {
	font-size: 11px;
	font-weight: 500;
	overflow: hidden;
	text-overflow: ellipsis;
	white-space: nowrap;
}

.game-card-id {
	font-size: 9px;
	color: #6c757d;
}

.theme-dark .game-card-id {
	color: #778399;
}

.selected-games-box {
	border: 1px solid #dcdfe3;
	border-radius: 4px;
	padding: 10px;
	background: #f8f9fa;
	max-height: 300px;
	overflow-y: auto;
	margin-top: 10px;
}

.theme-dark .selected-games-box {
	border-color: #3b4a5e;
	background: #1c203a;
}

.selected-game-item {
	display: flex;
	align-items: center;
	padding: 5px;
	margin-bottom: 5px;
	background: #fff;
	border-radius: 4px;
	border: 1px solid #e0e0e0;
}

.theme-dark .selected-game-item {
	background: #333a59;
	border-color: #4d5579;
}

.selected-game-item img {
	width: 40px;
	height: 40px;
	object-fit: cover;
	border-radius: 4px;
	margin-right: 10px;
}

.selected-game-item .game-info {
	flex: 1;
	font-size: 13px;
}

.selected-game-item .order-controls {
	display: flex;
	flex-direction: column;
	margin-right: 8px;
}

.selected-game-item .order-btn {
	background: none;
	border: none;
	color: #6c757d;
	cursor: pointer;
	padding: 2px 6px;
	font-size: 14px;
	line-height: 1;
}

.theme-dark .selected-game-item .order-btn {
	color: #778399;
}

.selected-game-item .order-btn:hover {
	color: #19bae0;
}

.selected-game-item .order-btn:disabled {
	color: #dee2e6;
	cursor: not-allowed;
}

.theme-dark .selected-game-item .order-btn:disabled {
	color: #566276;
}

.selected-game-item .remove-btn {
	color: #dc3545;
	cursor: pointer;
	padding: 5px 10px;
}

.selected-game-item .remove-btn:hover {
	color: #bd2130;
}

.collection-stats {
	padding: 10px;
	background: #e9ecef;
	border-radius: 4px;
	margin-bottom: 10px;
}

.theme-dark .collection-stats {
	background: #333a59;
}

.load-more-btn {
	width: 100%;
	margin-top: 10px;
}

.grid-mode-indicator {
	font-size: 12px;
	color: #6c757d;
	margin-bottom: 10px;
}

.theme-dark .grid-mode-indicator {
	color: #778399;
}
</style>

<div class="section section-full">
	<ul class="nav nav-tabs custom-tab" role="tablist">
		<li class="nav-item" role="presentation">
			<a class="nav-link active"><?php _e('Edit collection') ?></a>
		</li>
	</ul>
	<div class="general-wrapper">
		<form action="request.php" method="post">
			<input type="hidden" name="action" value="editCollection">
			<input type="hidden" name="redirect" value="dashboard.php?viewpage=collections&slug=edit&id=<?php echo $_GET['id'] ?>">
			<input type="hidden" name="id" value="<?php echo $_GET['id'] ?>"/>
			<input type="hidden" name="data" id="collection-data" value="<?php echo $collection->data ?>">
			
			<div class="row">
				<div class="col-md-8">
					<div class="mb-3">
						<label class="form-label"><?php _e('Collection Name') ?>:</label>
						<input type="text" class="form-control" name="name" placeholder="Collection name" required minlength="2" maxlength="255" value="<?php echo $collection->name ?>">
					</div>
					<div class="mb-3">
						<label class="form-label"><?php _e('Collection Slug') ?>:</label>
						<input type="text" class="form-control" name="slug" placeholder="collection-slug" required minlength="2" maxlength="255" value="<?php echo $collection->slug ?>">
					</div>
					<div class="mb-3">
						<label class="form-label"><?php _e('Description') ?>:</label>
						<textarea class="form-control" name="description" rows="3" placeholder="Collection description" maxlength="1000"><?php echo $collection->description ?></textarea>
					</div>
					
					<!-- Game Selection Section -->
					<div class="game-picker-section">
						<h5><?php _e('Select Games') ?></h5>
						<div class="game-search-box">
							<input type="text" class="form-control" id="game-search-input" placeholder="<?php _e('Search games...') ?>">
							<div class="search-spinner">
								<i class="fa fa-spinner fa-spin"></i>
							</div>
						</div>
						
						<div class="d-flex justify-content-between mb-2">
							<div class="grid-mode-indicator" id="grid-mode-indicator">
								<?php _e('Showing recent games') ?>
							</div>
							<div>
								<button type="button" class="btn btn-sm btn-outline-primary" id="select-visible-games"><?php _e('Select Visible') ?></button>
								<button type="button" class="btn btn-sm btn-outline-secondary" id="deselect-visible-games"><?php _e('Deselect Visible') ?></button>
							</div>
						</div>
						
						<div id="game-grid" class="game-grid">
							<div class="text-center p-4">
								<i class="fa fa-spinner fa-spin fa-2x"></i>
								<p><?php _e('Loading games...') ?></p>
							</div>
						</div>
						
						<button type="button" class="btn btn-secondary btn-sm load-more-btn" id="load-more-games" style="display: none;">
							<?php _e('Load More') ?>
						</button>
					</div>
					
					<!-- Selected Games Display -->
					<div class="collection-stats">
						<strong><span id="selected-count">0</span></strong> <?php _e('games selected') ?>
					</div>
					<div class="selected-games-box mb-3" id="selected-games-box">
						<!-- Selected games will appear here -->
					</div>
					
					<!-- Allow Dedicated Page -->
					<div class="mb-3">
						<input id="allow_dedicated_page" name="allow_dedicated_page" type="checkbox" <?php echo $collection->allow_dedicated_page ? 'checked' : '' ?>>
						<label class="form-label" for="allow_dedicated_page"><?php _e('Allow dedicated page') ?></label>
						<a href="<?php echo get_permalink('collection', $collection->slug) ?>" target="_blank" class="btn btn-sm btn-outline-success ms-2" id="preview-btn" style="<?php echo !$collection->allow_dedicated_page ? 'display: none;' : '' ?>">
							<i class="fa fa-external-link-alt"></i> <?php _e('Preview') ?>
						</a>
					</div>
				</div>
				
				<div class="col-md-4">
					<!-- Empty for now, can add stats or other options later -->
				</div>
			</div>
			
			<button type="submit" class="btn btn-primary"><?php _e('Save Changes') ?></button>
		</form>
	</div>
</div>

<script>
(function($) {
	let selectedGames = [];
	let loadedGames = {};
	let searchTimeout = null;
	let currentPage = 0;
	let hasMoreGames = true;
	let currentSearchTerm = '';
	let isSearchMode = false;
	
	// Initialize with existing games
	function initializeSelectedGames() {
		const dataField = $('#collection-data').val();
		if (dataField) {
			selectedGames = dataField.split(',').filter(id => id !== '');
			updateSelectedCount();
			loadSelectedGamesData();
		}
	}
	
	// Load data for already selected games
	function loadSelectedGamesData() {
		if (selectedGames.length === 0) return;
		
		$.ajax({
			url: 'includes/ajax-actions.php',
			method: 'POST',
			data: { 
				action: 'get_games_by_ids',
				ids: selectedGames.join(',')
			},
			dataType: 'json',
			success: function(response) {
				if (response.status === 'success') {
					response.games.forEach(game => {
						loadedGames[game.id] = game;
					});
					renderSelectedGames();
				}
			}
		});
	}
	
	// Load recent games
	function loadRecentGames() {
		isSearchMode = false;
		$('#grid-mode-indicator').text('<?php _e("Showing recent games") ?>');
		
		$.ajax({
			url: 'includes/ajax-actions.php',
			method: 'POST',
			data: { 
				action: 'get_recent_games_for_picker',
				limit: 30
			},
			dataType: 'json',
			success: function(response) {
				if (response.status === 'success') {
					response.games.forEach(game => {
						loadedGames[game.id] = game;
					});
					renderGameGrid(response.games, false);
					$('#load-more-games').hide();
				} else {
					$('#game-grid').html('<div class="text-center p-4 text-danger"><?php _e("Error loading games") ?></div>');
				}
			},
			error: function() {
				$('#game-grid').html('<div class="text-center p-4 text-danger"><?php _e("Failed to load games") ?></div>');
			}
		});
	}
	
	// Search games
	function searchGames(searchTerm, page = 0, append = false) {
		if (searchTerm.length === 0) {
			loadRecentGames();
			return;
		}
		
		if (searchTerm.length < 2) {
			return;
		}
		
		isSearchMode = true;
		$('#grid-mode-indicator').text('<?php _e("Search results") ?>');
		$('.search-spinner').show();
		
		$.ajax({
			url: 'includes/ajax-actions.php',
			method: 'POST',
			data: { 
				action: 'search_games_for_picker',
				search: searchTerm,
				page: page,
				limit: 30
			},
			dataType: 'json',
			success: function(response) {
				$('.search-spinner').hide();
				
				if (response.status === 'success') {
					response.games.forEach(game => {
						loadedGames[game.id] = game;
					});
					
					renderGameGrid(response.games, append);
					hasMoreGames = response.has_more;
					
					$('#load-more-games').toggle(hasMoreGames);
				} else {
					if (!append) {
						$('#game-grid').html('<div class="text-center p-4 text-danger"><?php _e("Error loading games") ?></div>');
					}
				}
			},
			error: function() {
				$('.search-spinner').hide();
				if (!append) {
					$('#game-grid').html('<div class="text-center p-4 text-danger"><?php _e("Failed to load games") ?></div>');
				}
			}
		});
	}
	
	// Render game grid
	function renderGameGrid(games, append = false) {
		const grid = $('#game-grid');
		
		if (!append) {
			grid.empty();
		}
		
		if (games.length === 0 && !append) {
			grid.html('<div class="text-center p-4"><?php _e("No games found") ?></div>');
			return;
		}
		
		games.forEach(game => {
			const isSelected = selectedGames.includes(game.id.toString());
			const card = $(`
				<div class="game-card ${isSelected ? 'selected' : ''}" data-game-id="${game.id}">
					<img src="${game.thumb || '/images/default-thumb.png'}" alt="${game.title}" loading="lazy">
					<div class="game-card-title" title="${game.title}">${game.title}</div>
					<div class="game-card-id">ID: ${game.id}</div>
				</div>
			`);
			
			card.on('click', function() {
				toggleGameSelection(game.id.toString());
			});
			
			grid.append(card);
		});
	}
	
	// Toggle game selection
	function toggleGameSelection(gameId) {
		const index = selectedGames.indexOf(gameId);
		if (index > -1) {
			selectedGames.splice(index, 1);
		} else {
			selectedGames.push(gameId);
		}
		
		$(`.game-card[data-game-id="${gameId}"]`).toggleClass('selected');
		updateSelectedCount();
		updateDataField();
		renderSelectedGames();
	}
	
	// Move game up in order
	function moveGameUp(gameId) {
		const index = selectedGames.indexOf(gameId);
		if (index > 0) {
			[selectedGames[index - 1], selectedGames[index]] = [selectedGames[index], selectedGames[index - 1]];
			updateDataField();
			renderSelectedGames();
		}
	}
	
	// Move game down in order
	function moveGameDown(gameId) {
		const index = selectedGames.indexOf(gameId);
		if (index < selectedGames.length - 1) {
			[selectedGames[index], selectedGames[index + 1]] = [selectedGames[index + 1], selectedGames[index]];
			updateDataField();
			renderSelectedGames();
		}
	}
	
	// Update selected count
	function updateSelectedCount() {
		$('#selected-count').text(selectedGames.length);
	}
	
	// Update hidden data field
	function updateDataField() {
		$('#collection-data').val(selectedGames.join(','));
	}
	
	// Render selected games list
	function renderSelectedGames() {
		const box = $('#selected-games-box');
		box.empty();
		
		if (selectedGames.length === 0) {
			box.html('<p class="text-center text-muted"><?php _e("No games selected") ?></p>');
			return;
		}
		
		selectedGames.forEach((gameId, index) => {
			const game = loadedGames[gameId];
			if (game) {
				const isFirst = index === 0;
				const isLast = index === selectedGames.length - 1;
				
				const item = $(`
					<div class="selected-game-item">
						<div class="order-controls">
							<button type="button" class="order-btn up-btn" data-game-id="${gameId}" ${isFirst ? 'disabled' : ''}>
								<i class="fa fa-chevron-up"></i>
							</button>
							<button type="button" class="order-btn down-btn" data-game-id="${gameId}" ${isLast ? 'disabled' : ''}>
								<i class="fa fa-chevron-down"></i>
							</button>
						</div>
						<img src="${game.thumb || '/images/default-thumb.png'}" alt="${game.title}">
						<div class="game-info">
							<strong>${game.title}</strong><br>
							<small>ID: ${game.id}</small>
						</div>
						<span class="remove-btn" data-game-id="${gameId}">
							<i class="fa fa-times"></i>
						</span>
					</div>
				`);
				
				item.find('.up-btn').on('click', function() {
					moveGameUp(gameId);
				});
				
				item.find('.down-btn').on('click', function() {
					moveGameDown(gameId);
				});
				
				item.find('.remove-btn').on('click', function() {
					toggleGameSelection(gameId);
				});
				
				box.append(item);
			}
		});
	}
	
	// Search with debounce
	$('#game-search-input').on('input', function() {
		const searchTerm = $(this).val();
		currentSearchTerm = searchTerm;
		currentPage = 0;
		hasMoreGames = true;
		
		clearTimeout(searchTimeout);
		searchTimeout = setTimeout(function() {
			searchGames(searchTerm, 0, false);
		}, 500);
	});
	
	// Load more
	$('#load-more-games').on('click', function() {
		if (isSearchMode) {
			currentPage++;
			searchGames(currentSearchTerm, currentPage, true);
		}
	});
	
	// Select/Deselect visible
	$('#select-visible-games').on('click', function() {
		$('.game-card:visible').each(function() {
			const gameId = $(this).data('game-id').toString();
			if (!selectedGames.includes(gameId)) {
				selectedGames.push(gameId);
				$(this).addClass('selected');
			}
		});
		updateSelectedCount();
		updateDataField();
		renderSelectedGames();
	});
	
	$('#deselect-visible-games').on('click', function() {
		$('.game-card:visible').each(function() {
			const gameId = $(this).data('game-id').toString();
			selectedGames = selectedGames.filter(id => id !== gameId);
			$(this).removeClass('selected');
		});
		updateSelectedCount();
		updateDataField();
		renderSelectedGames();
	});
	
	// Toggle preview button visibility
	$('#allow_dedicated_page').on('change', function() {
		if ($(this).is(':checked')) {
			$('#preview-btn').show();
		} else {
			$('#preview-btn').hide();
		}
	});
	
	// Initialize
	initializeSelectedGames();
	loadRecentGames();
	
})(jQuery);
</script>
		<?php
	}
}

?>