<div class="row">
	<div class="col-lg-8">
		<div class="section">
			<ul class="collection-list">
				<?php
				$results = array();
				$data = Collection::getList();
				if ($data['totalRows'] > 0) {
					$collections = $data['results'];
					foreach ($collections as $item) {
						echo '<li class="collection-item d-flex align-items-center">';
						echo esc_string($item->name);
						echo '<div style="margin-left: auto;">';
						echo '<span class="actions">';
						if ($item->allow_dedicated_page) {
							echo '<a class="text-success" href="'.get_permalink('collection', $item->slug).'" target="_blank"><i class="fa fa-external-link-alt circle" aria-hidden="true"></i></a>';
						}
						if($can_edit_collection){
							echo '<a href="dashboard.php?viewpage=collections&slug=edit&id='.esc_int($item->id).'"><i class="fa fa-pencil-alt circle" aria-hidden="true"></i></a>';
						}
						if($can_delete_collection){
							echo '<a class="remove-collection text-danger" href="#" id="' . esc_int($item->id) . '"><i class="fa fa-trash circle" aria-hidden="true"></i></a>';
						}
						echo '</span>';
						echo '</div></li>';
					}
				} else {
					_e('No collections found!');
				}
				?>
			</ul>
		</div>
	</div>
	<?php if($can_add_collection){ ?>
	<div class="col-lg-4">
		<div class="section">
			<form id="form-newcollection" action="request.php" method="post">
				<input type="hidden" name="action" value="newCollection">
				<div class="mb-3">
					<label for="collection"><?php _e('Add new collection') ?>:</label>
					<input type="text" class="form-control" name="name" placeholder="Collection Name" value="" minlength="2" maxlength="50" required>
				</div>
				<button type="submit" class="btn btn-primary btn-md"><?php _e('Create Collection') ?></button>
			</form>
		</div>
	</div>
	<?php } ?>
</div>